/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.hwyla;

import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntityAbstract;
import cy.jdkdigital.productivebees.common.block.entity.SolitaryNestBlockEntity;
import java.util.List;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SolitaryNestProvider
implements IComponentProvider,
IServerDataProvider<BlockEntity> {
    static final SolitaryNestProvider INSTANCE = new SolitaryNestProvider();

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (!(blockEntity instanceof SolitaryNestBlockEntity)) {
            return;
        }
        SolitaryNestBlockEntity tileEntity = (SolitaryNestBlockEntity)blockEntity;
        tileEntity.loadPacketNBT(accessor.getServerData());
        List<AdvancedBeehiveBlockEntityAbstract.Inhabitant> bees = tileEntity.getBeeList();
        if (!bees.isEmpty()) {
            tooltip.add((Component)new TranslatableComponent("productivebees.top.solitary.bee", new Object[]{bees.get((int)0).localizedName}));
        } else {
            int cooldown = tileEntity.getNestTickCooldown();
            if (cooldown > 0) {
                tooltip.add((Component)new TranslatableComponent("productivebees.top.solitary.repopulation_countdown", new Object[]{Math.round((float)cooldown / 20.0f) + "s"}));
            } else {
                tooltip.add((Component)new TranslatableComponent("productivebees.top.solitary.repopulation_countdown_inactive"));
                if (tileEntity.canRepopulate()) {
                    tooltip.add((Component)new TranslatableComponent("productivebees.top.solitary.can_repopulate_true"));
                } else {
                    tooltip.add((Component)new TranslatableComponent("productivebees.top.solitary.can_repopulate_false"));
                }
            }
        }
    }

    public void appendServerData(CompoundTag tag, ServerPlayer player, Level world, BlockEntity te, boolean showDetails) {
        tag.m_128431_().clear();
        if (te instanceof SolitaryNestBlockEntity) {
            SolitaryNestBlockEntity nest = (SolitaryNestBlockEntity)te;
            nest.savePacketNBT(tag);
        }
    }
}

